package application;
	
import java.io.IOException;
import java.lang.reflect.Constructor;

import application.model.GPGState;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;


public class Main extends Application {
	
	private Stage primaryStage;
	private AnchorPane rootLayout;
	private GPGState state; //Model
	private MainController main_controller;

	@Override
    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.primaryStage.setTitle("Assinador");
        
        state = new GPGState(); //Initialize model
        
        initRootLayout();
        
        if(!state.getKeysCreated()){
        	newKeyLayout();
        }else{
        	//Pedir senha para destravar
        }
    }
	
	public void initRootLayout(){
		try {
            // Loads the rootLayout
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/Interface.fxml"));
            
            //Injection using reflection code retrieved from
            // http://stackoverflow.com/questions/40539310/dependency-injection-and-javafx
            loader.setControllerFactory((Class<?> type) -> {
                try {
                    //Finds the constructor that accepts an instance of Main
                    for (Constructor<?> c : type.getConstructors()) {
                        if (c.getParameterCount() == 1) {
                            if (c.getParameterTypes()[0] == Main.class) {
                                return c.newInstance(this);
                            }
                        }
                    }

                    //Otherwise uses default constructor
                    return type.newInstance();
                } catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
            rootLayout = (AnchorPane) loader.load();
            main_controller = loader.getController();
            
            // Show the scene with the rootLayout
            Scene scene = new Scene(rootLayout);
            primaryStage.setScene(scene);
            primaryStage.setResizable(true);
            
            primaryStage.show();
        } catch (IOException e) {
            e.printStackTrace();
        }
	}
	
	public void newKeyLayout(){
		try {
			Stage secondaryStage = new Stage();
			AnchorPane newKeyLayout;
			
			secondaryStage.initOwner(primaryStage);
			secondaryStage.setResizable(false);
            secondaryStage.setTitle("Assinador - Criação de chaves");
            secondaryStage.initModality(Modality.APPLICATION_MODAL);
			
            // Loads the new key layout
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/newKey.fxml"));
            newKeyLayout = (AnchorPane) loader.load();
            
            NewKeyController controller = loader.getController();
            controller.setMainApp(this);
            controller.setStage(secondaryStage);
            
            // Show the scene with the new key layout
            Scene scene = new Scene(newKeyLayout);
            secondaryStage.setScene(scene);
            
            secondaryStage.show();
        } catch (IOException e) {
            e.printStackTrace();
        }
	}
	
	public Stage getPrimaryStage() {
		return primaryStage;
	}
	
	public GPGState getState(){
		return state;
	}

	public MainController getMain_controller() {
		return main_controller;
	}

	@Override
	public void stop(){
		Platform.exit();
	    System.exit(0);
	}
	
	public static void main(String[] args) {
		launch(args);
	}
}
