package application;


import java.io.File;
import java.util.List;
import java.util.Optional;

import application.model.TableModel;
import application.utils.AlertFactory;
import application.utils.DialogPassword;
import application.utils.DialogProgressBar;
import javafx.beans.binding.Bindings;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.util.Callback;

public class MainController{
	
	private Main main;

	@FXML
	private MenuBar menu_bar;

	@FXML
	private MenuItem menu_sobre;
	
	@FXML
	private MenuItem menu_sair;
	
	@FXML
	private MenuItem menu_revogar;
	
	@FXML
	private MenuItem menu_criar;
	
	@FXML
	private Button btn_assinar;
	
	@FXML
	private Button btn_abrir;
	
	@FXML
	private Button btn_executar_pendentes;

	@FXML
	private Button btn_limpar;

	@FXML
	private Label text_fingerprint;
	
	@FXML
	private Label text_expiration;

	@FXML
	private TableView<TableModel> tableview;

	@FXML
	private TableColumn<TableModel, String> column_nome;

	@FXML
	private TableColumn<TableModel, String> column_caminho;

	@FXML
	private TableColumn<TableModel, String> column_acao;

	@FXML
	public void abrir_criacao(){
		main.newKeyLayout();
	}
	
	@FXML
	public void sobre_dialog(){
		String title = "Assinador SIGFAP";
		String header = "Assinador SIGFAP";
		String content = "Assinador SIGFAP\nVersão 0.0.1-dev";

		Alert alerta = AlertFactory.getAlert(AlertType.INFORMATION, title, header, content);

		alerta.show();
	}
	
	@FXML
	public void revogar_chave(){
		String title = "Revogação de chaves";
		String header= "Revogação de chaves";
		String content = "Deseja revogar a chave com id\n" + main.getState().getUserID() + "?\n\nEssa operação não pode ser desfeita\n";
		Alert alerta = AlertFactory.getAlert(AlertType.CONFIRMATION, title, header, content);
		
		Optional<ButtonType> result = alerta.showAndWait();
		if (result.get() == ButtonType.OK){
			//Revoke key
		} else {
			//Dont revoke key/no action
		}
	}
	
	@FXML
	public void selecionar_arquivos_assinar(){
		FileChooser fileChooser = new FileChooser();
		fileChooser.setTitle("Selecionar arquivos para assinar");

		fileChooser.getExtensionFilters().addAll(
                new FileChooser.ExtensionFilter("PDF", "*.pdf")
        );
		List<File> list = fileChooser.showOpenMultipleDialog(main.getPrimaryStage());
		
		if (list == null)
			return;

		for(File file : list){
			main.getState().add_to_sign(file);
		}
	}
	
	@FXML
	public void selecionar_arquivos_abrir(){
		FileChooser fileChooser = new FileChooser();
		fileChooser.setTitle("Selecionar arquivos para abrir");

		fileChooser.getExtensionFilters().addAll(
                new FileChooser.ExtensionFilter(".compressed.sig", "*.compressed.sig")
        );

		List<File> list = fileChooser.showOpenMultipleDialog(main.getPrimaryStage());
		
		if (list == null)
			return;

		for(File file : list){
			main.getState().add_to_decompress(file);
		}
	}
	
	@FXML
	public void sign_pending(){
		if(!main.getState().isPendingEmpty()){
			return;
		}

		char[] password;
		do{
			DialogPassword dialog = new DialogPassword();
			Optional<char[]> result = dialog.showAndWait();
			password = result.get();
		}while(password.length == 0);

		Task<?> sign_task = main.getState().sign(password);

		password = null;

		DialogProgressBar progress = new DialogProgressBar("Assinando os arquivos", "Aguarde enquanto a operação é executada");
		progress.initModality(Modality.APPLICATION_MODAL);
		progress.show();

		Thread thread = new Thread(sign_task);
		thread.start();
		try {
			thread.join();

			if(progress.isShowing())
				progress.close();

			String title2 = "Arquivos assinados!";
			String header2 = "Arquivos assinados!";
			String content2 = "Os arquivos foram assinados!";

			Alert alert2 = AlertFactory.getAlert(AlertType.INFORMATION, title2, header2, content2);

			alert2.showAndWait();

		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		System.gc();
	}

	@FXML
	public void decompress(){
		if(!main.getState().isDecompressionEmpty()){
			return;
		}

		Task<?> decompress_task = main.getState().decompress();

		DialogProgressBar progress = new DialogProgressBar("Descomprimindo e verificando os arquivos", "Aguarde enquanto a operação é executada");
		progress.initModality(Modality.APPLICATION_MODAL);
		progress.show();

		Thread thread = new Thread(decompress_task);
		thread.start();
		try {
			thread.join();

			if(progress.isShowing())
				progress.close();

			String title = "Arquivos descomprimidos!";
			String header = "Arquivos descomprimidos!";
			String content = "Os arquivos foram descomprimidos!";

			Alert alert = AlertFactory.getAlert(AlertType.INFORMATION, title, header, content);

			alert.showAndWait();

		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	@FXML
	public void executar_pendentes(){
		if(!main.getState().isDecompressionEmpty() && !main.getState().isPendingEmpty()){
			String title = "Não há tarefas pendentes";
			String content = "Não há tarefas pendentes!";

			Alert alert = AlertFactory.getAlert(AlertType.INFORMATION, title, null, content);

			alert.showAndWait();
		}

		sign_pending();
		decompress();

		main.getState().getTableModel().clear();
	}

	@FXML
	public void limpar(){
		main.getState().getTableModel().clear();
	}

	@FXML
	public void sair(){
		try {
			main.stop();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void updateKeyInfo(){
		text_fingerprint.setText("Fingerprint: " + main.getState().getFingerprint());
		text_expiration.setText("Data expiração: " + main.getState().getExpiryDate());
	}
	
	public MainController(Main main){
		this.main = main;
	}

	public void initialize(){
		menu_bar.useSystemMenuBarProperty().set(true);

		if(!main.getState().getKeysCreated())
			updateButtonsDisabledState(true);
		else
			menu_criar.setDisable(true);

		updateKeyInfo();

		column_nome.setCellValueFactory(
				new PropertyValueFactory<TableModel, String>("arquivo_nome"));

		column_caminho.setCellValueFactory(
				new PropertyValueFactory<TableModel, String>("arquivo_caminho"));

		column_acao.setCellValueFactory(
				new PropertyValueFactory<TableModel, String>("arquivo_acao"));

		tableview.setRowFactory(
				new Callback<TableView<TableModel>, TableRow<TableModel>>() {
					@Override
					public TableRow<TableModel> call(TableView<TableModel> param) {
						final TableRow<TableModel> row = new TableRow<>();
					    final ContextMenu rowMenu = new ContextMenu();
					    MenuItem removeItem = new MenuItem("Remover");
					    removeItem.setOnAction(new EventHandler<ActionEvent>() {
					      @Override
					      public void handle(ActionEvent event) {
					        tableview.getItems().remove(row.getItem());
					      }
					    });
					    rowMenu.getItems().addAll(removeItem);

					    // only display context menu for non-null items:
					    row.contextMenuProperty().bind(
					      Bindings.when(Bindings.isNotNull(row.itemProperty()))
					      .then(rowMenu)
					      .otherwise((ContextMenu)null));
					    return row;
					}
				}
		);

		tableview.setItems(main.getState().getTableModel());
	}

	public void updateButtonsDisabledState(boolean state){
		btn_assinar.setDisable(state);
		btn_abrir.setDisable(state);
		menu_revogar.setDisable(state);
		btn_executar_pendentes.setDisable(state);
		menu_criar.setDisable(!state);
	}
}
