package application;

import java.io.File;

import application.utils.AlertFactory;
import application.utils.DialogProgressBar;
import application.utils.MascarasFX;
import application.utils.ValidarCPF;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import libsigner.Utils;

public class NewKeyController {

	private Main main;
	
	private Stage stage;
	
	@FXML
	private TextField text_caminho_autorizacao;
	
	@FXML
	private Button btn_caminho_autorizacao;
	
	@FXML
	private Button btn_cancelar_criacao;

	@FXML
	private Button btn_criar_chave;
	
	@FXML
	private PasswordField text_password;

	@FXML
	private PasswordField text_password_confirmation;

	@FXML
	private TextField text_nome_completo;

	@FXML
	private TextField text_cpf;

	@FXML
	private TextField text_email;

	@FXML
	public void select_autorizacao(){
		FileChooser fileChooser = new FileChooser();
		fileChooser.setTitle("Selecione o arquivo de autorização");
		
		File file = fileChooser.showOpenDialog(stage);
	}
	
	@FXML
	private void validate_and_generate(){
		String nome = text_nome_completo.getText();
		String cpf = ValidarCPF.pegarSomenteNumerosCPF(text_cpf.getText());
		String email = text_email.getText();

		if( nome.isEmpty() || cpf.isEmpty() || email.isEmpty() || text_password.getText().isEmpty() || text_password_confirmation.getText().isEmpty() ){
			String title = "Criação de chaves";
			String content = "Todos os campos devem ser preenchidos";

			Alert alert = AlertFactory.getAlert(AlertType.ERROR, title, null, content);

			alert.showAndWait();
			
			return;
		}

		boolean valido = ValidarCPF.isCPF(cpf);

		if(!valido){
			String title = "Criação de chaves";
			String content = "CPF inválido";

			Alert alert = AlertFactory.getAlert(AlertType.ERROR, title, null, content);

			alert.showAndWait();

			text_cpf.clear();
			text_password.clear();
			text_password_confirmation.clear();

			return;
		}

		if(!text_password.getText().matches("^(?=.*[0-9])(?=.*[A-Z])(?=.*\\p{Punct})(?=\\S+$).{8,}$")){
			String title = "Criação de chaves";
			String content = "Senhas fora do padrão";

			Alert alert = AlertFactory.getAlert(AlertType.ERROR, title, null, content);

			alert.showAndWait();

			return;
		}

		if(!text_password.getText().equals(text_password_confirmation.getText())){
			String title = "Criação de chaves";
			String content = "Senhas não conferem";

			Alert alert = AlertFactory.getAlert(AlertType.ERROR, title, null, content);

			alert.showAndWait();

			text_password.clear();
			text_password_confirmation.clear();

			return;
		}

		String id = String.format("%s (%s) <%s>", nome, cpf, email);

		Task<Void> generate = new Task<Void>() {
			@Override
			protected Void call() throws Exception {
				Utils.generateRSAPair(id, text_password.getText().toCharArray() , "pubring.gpg", "secring.gpg");

				return null;
			}
		};

		Thread thread = new Thread(generate);

		DialogProgressBar progress = new DialogProgressBar("Gerando a chave", "Aguarde enquanto a operação é executada");
		progress.initModality(Modality.APPLICATION_MODAL);
		progress.show();

		thread.start();

		try {
			thread.join();

			if(progress.isShowing())
				progress.close();

		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		stage.close();

		main.getState().updateKeyInfo();

		if(main.getState().getKeysCreated()){
			main.getMain_controller().updateKeyInfo();
			main.getMain_controller().updateButtonsDisabledState(false);

			String title = "Criação de chaves";
			String content = "Chaves criadas com sucesso!";

			Alert alert = AlertFactory.getAlert(AlertType.INFORMATION, title, null, content);

			alert.showAndWait();
		}else{
			String title = "Criação de chaves";
			String content = "Erro na criação de chaves!";

			Alert alert = AlertFactory.getAlert(AlertType.ERROR, title, null, content);

			alert.showAndWait();
		}
	}

	@FXML
	public void cancelar_criacao(){
		stage.close();
	}
	
	public void setMainApp(Main main) {
		this.main = main;
	}

	public void setStage(Stage secondaryStage) {
		this.stage = secondaryStage;
	}

	@FXML
	public void initialize(){
		MascarasFX.mascaraCPF(text_cpf);
		MascarasFX.mascaraEmail(text_email);
	}

}
