package application.utils;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

//Based on https://gist.github.com/drguildo/ba2834bf52d624113041

public class DialogPassword extends Dialog<char[]> {
	private PasswordField passwordField;
	private Label label;
	
	public DialogPassword() {
		setTitle("Abrir chave privada");
	    setHeaderText("Abrir chave privada");

	    ButtonType passwordButtonType = new ButtonType("Assinar", ButtonData.OK_DONE);
	    getDialogPane().getButtonTypes().addAll(passwordButtonType, ButtonType.CANCEL);

	    passwordField = new PasswordField();
	    passwordField.setPromptText("Senha");
	    
	    label = new Label("Digite sua senha: ");
	    
	    HBox hBox = new HBox();
	    hBox.getChildren().add(label);
	    hBox.getChildren().add(passwordField);
	    hBox.setPadding(new Insets(20));
	    hBox.setSpacing(10);

	    HBox.setHgrow(passwordField, Priority.ALWAYS);

	    getDialogPane().setContent(hBox);

	    Platform.runLater(() -> passwordField.requestFocus());

	    setResultConverter(dialogButton -> {
	      if (dialogButton == passwordButtonType) {
	        return passwordField.getText().toCharArray();
	      }
	      return null;
	    });
	}
	
	public PasswordField getPasswordField(){
		return passwordField;
	}
}
