package application.utils;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DialogProgressBar extends Dialog<Void> {
	
	private ProgressBar progressbar;
	
	public DialogProgressBar(String title, String header) {
		setTitle(title);
		setHeaderText(header);
		
		progressbar = new ProgressBar();
		progressbar.setProgress(-1);
		
		VBox vb = new VBox();
        vb.setAlignment(Pos.CENTER);
	    vb.setSpacing(12);
	    vb.setPadding(new Insets(15,12,0,12));
        vb.getChildren().addAll(progressbar);
        
        VBox.setVgrow(progressbar, Priority.ALWAYS);
        
        getDialogPane().setContent(vb);
        
        getDialogPane().getButtonTypes().add(ButtonType.CLOSE);
        Node closeButton = getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind(closeButton.visibleProperty());
        closeButton.setVisible(false);
	}

}
