#!/bin/sh

n=$((`maas root nodes list | grep system`+1))

scp scripts/create_node_1024.sh root@cloud0:~/
ssh root@cloud0 ./create_node_1024.sh $n

echo "[ MAAS ] Declaring Machine..."
sleep 2m
echo "New Node Declared!"
node_id=`maas root nodes list | grep system | cut -d ":" -f2 | tail -n 1 | cut -d "\"" -f2`

echo "[ MAAS ] Updating Node..."
maas root node update $node_id power_type="virsh" power_parameters_power_address="qemu+ssh://root@10.90.0.6/system" power_parameters_power_id="node$n" hostname="node$n"

echo "[ MAAS ] Commissioning Node..."
maas root node commission $node_id
echo "[ MAAS ] Node must be ready in few minutes."
